/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_wbm.element;

import com.fuzs.puzzleslib_wbm.config.ConfigManager;
import com.fuzs.puzzleslib_wbm.element.AbstractElement;
import com.fuzs.puzzleslib_wbm.element.ISidedElement;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public abstract class ElementRegistry {
    private static final Map<ResourceLocation, AbstractElement> ELEMENTS = Maps.newHashMap();

    protected static AbstractElement register(String namespace, String key, AbstractElement element) {
        if (element instanceof ISidedElement) {
            ResourceLocation location = new ResourceLocation(namespace, key);
            ELEMENTS.put(location, element);
            element.setRegistryName(location);
            return element;
        }
        throw new RuntimeException("Unable to register element: Invalid element, no instance of ISidedElement");
    }

    public static Optional<AbstractElement> get(String namespace, String key) {
        return Optional.ofNullable(ELEMENTS.get(new ResourceLocation(namespace, key)));
    }

    public static Optional<Object> getConfigValue(String namespace, String key, String ... path) {
        Optional<AbstractElement> element = ElementRegistry.get(namespace, key);
        if (element.isPresent()) {
            return ElementRegistry.getConfigValue(element.get(), path);
        }
        return Optional.empty();
    }

    public static <T extends AbstractElement> T getAs(AbstractElement element) {
        return (T)element;
    }

    public static Optional<Object> getConfigValue(AbstractElement element, String ... path) {
        if (element.isEnabled()) {
            String fullPath = Stream.concat(Stream.of(element.getRegistryName()), Stream.of(path)).collect(Collectors.joining("."));
            return Optional.of(ConfigManager.get().getValueFromPath(fullPath));
        }
        return Optional.empty();
    }

    protected static void setup(String namespace) {
        Map<ResourceLocation, AbstractElement> elements = ElementRegistry.getOwnElements(namespace);
        ConfigManager.builder().create("general", builder -> elements.values().forEach(element -> element.setupGeneralConfig((ForgeConfigSpec.Builder)builder)), ElementRegistry.getSide(elements.values()), new String[0]);
        elements.values().forEach(AbstractElement::setup);
    }

    private static Map<ResourceLocation, AbstractElement> getOwnElements(String namespace) {
        return ELEMENTS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).func_110624_b().equals(namespace)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void load() {
        ELEMENTS.values().forEach(AbstractElement::load);
        ELEMENTS.values().stream().filter(element -> element instanceof ISidedElement.Common).map(element -> (ISidedElement.Common)((Object)element)).forEach(ISidedElement.Common::loadCommon);
    }

    public static void loadClient() {
        ELEMENTS.values().stream().filter(element -> element instanceof ISidedElement.Client).map(element -> (ISidedElement.Client)((Object)element)).forEach(ISidedElement.Client::loadClient);
    }

    public static void loadServer() {
        ELEMENTS.values().stream().filter(element -> element instanceof ISidedElement.Server).map(element -> (ISidedElement.Server)((Object)element)).forEach(ISidedElement.Server::loadServer);
    }

    private static ModConfig.Type getSide(Collection<AbstractElement> elements) {
        if (!elements.isEmpty()) {
            if (elements.stream().anyMatch(element -> element instanceof ISidedElement.Common)) {
                return ModConfig.Type.COMMON;
            }
            if (elements.stream().allMatch(element -> element instanceof ISidedElement.Client)) {
                return ModConfig.Type.CLIENT;
            }
            if (elements.stream().allMatch(element -> element instanceof ISidedElement.Server)) {
                return ModConfig.Type.SERVER;
            }
        }
        throw new RuntimeException("Mod has no elements");
    }
}

