/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_wbm.element;

import com.fuzs.puzzleslib_wbm.config.ConfigManager;
import com.fuzs.puzzleslib_wbm.config.deserialize.EntryCollectionBuilder;
import com.fuzs.puzzleslib_wbm.element.IConfigurableElement;
import com.fuzs.puzzleslib_wbm.element.ISidedElement;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractElement
implements IConfigurableElement {
    private final List<EventStorage<? extends Event>> events = Lists.newArrayList();
    private ResourceLocation registryName;
    private boolean enabled;
    @Nullable
    private ISidedElement.Client clientPerformer;
    @Nullable
    private ISidedElement.Server serverPerformer;

    public final void setRegistryName(ResourceLocation location) {
        if (this.registryName != null) {
            throw new RuntimeException("Unable to set registry name for element: Name already set");
        }
        this.registryName = location;
    }

    public final String getRegistryName() {
        if (this.registryName == null) {
            throw new RuntimeException("Unable to get registry name for element: Name not set");
        }
        return this.registryName.func_110623_a();
    }

    @Override
    public boolean getDefaultState() {
        return true;
    }

    @Override
    public final String getDisplayName() {
        return Stream.of(this.getRegistryName().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @Override
    public final void setupGeneralConfig(ForgeConfigSpec.Builder builder) {
        AbstractElement.addToConfig(builder.comment(this.getDescription()).define(this.getDisplayName(), this.getDefaultState()), this::setEnabled);
    }

    @Override
    public void unload() {
    }

    public final void setup() {
        this.setupPerformers();
        this.setupConfig(this.getRegistryName());
        this.setup(ISidedElement.Common::setupCommon, ISidedElement.Client::setupClient, ISidedElement.Server::setupServer);
    }

    private void setupPerformers() {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            Optional.ofNullable(this.createServerPerformer()).map(performer -> (ISidedElement.Abstract)performer.apply(this)).ifPresent(performer -> {
                if (!(performer instanceof ISidedElement.Server)) {
                    throw new RuntimeException("Performer does not implement ISidedElement.Server");
                }
                this.serverPerformer = (ISidedElement.Server)((Object)performer);
            });
        } else {
            Optional.ofNullable(this.createClientPerformer()).map(performer -> (ISidedElement.Abstract)performer.apply(this)).ifPresent(performer -> {
                if (!(performer instanceof ISidedElement.Client)) {
                    throw new RuntimeException("Performer does not implement ISidedElement.Client");
                }
                this.clientPerformer = (ISidedElement.Client)((Object)performer);
            });
        }
    }

    private void setup(Consumer<ISidedElement.Common> commonSetup, Consumer<ISidedElement.Client> clientSetup, Consumer<ISidedElement.Server> serverSetup) {
        if (this instanceof ISidedElement.Common) {
            commonSetup.accept((ISidedElement.Common)((Object)this));
        }
        if (this instanceof ISidedElement.Client) {
            clientSetup.accept((ISidedElement.Client)((Object)this));
        }
        if (this instanceof ISidedElement.Server) {
            serverSetup.accept((ISidedElement.Server)((Object)this));
        }
    }

    private void setupConfig(String elementId) {
        Consumer<ISidedElement.Common> commonSetup = element -> ConfigManager.builder().create(elementId, element::setupCommonConfig, ModConfig.Type.COMMON, new String[0]);
        Consumer<ISidedElement.Client> clientSetup = element -> ConfigManager.builder().create(elementId, element::setupClientConfig, ModConfig.Type.CLIENT, new String[0]);
        Consumer<ISidedElement.Server> serverSetup = element -> ConfigManager.builder().create(elementId, element::setupServerConfig, ModConfig.Type.SERVER, new String[0]);
        this.setup(commonSetup, clientSetup, serverSetup);
    }

    public final void load() {
        this.reload(true);
    }

    private void reload(boolean isInit) {
        if (this.isEnabled() || this.isAlwaysEnabled()) {
            this.events.forEach(EventStorage::register);
        } else if (!isInit) {
            this.events.forEach(EventStorage::unregister);
            this.unload();
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    protected boolean isAlwaysEnabled() {
        return false;
    }

    private void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.reload(false);
        }
    }

    @Nullable
    protected Function<AbstractElement, ISidedElement.Abstract<?>> createClientPerformer() {
        return null;
    }

    @Nullable
    protected Function<AbstractElement, ISidedElement.Abstract<?>> createServerPerformer() {
        return null;
    }

    protected final void performForClient(Consumer<ISidedElement.Client> consumer) {
        if (this.clientPerformer != null) {
            consumer.accept(this.clientPerformer);
        }
    }

    protected final void performForServer(Consumer<ISidedElement.Server> consumer) {
        if (this.serverPerformer != null) {
            consumer.accept(this.serverPerformer);
        }
    }

    public static <S extends ForgeConfigSpec.ConfigValue<T>, T> void addToConfig(S entry, Consumer<T> action) {
        ConfigManager.get().registerEntry(entry, action);
    }

    public static <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void addToConfig(S entry, Consumer<R> action, Function<T, R> transformer) {
        ConfigManager.get().registerEntry(entry, action, transformer);
    }

    public static <T extends IForgeRegistryEntry<T>> Set<T> deserializeToSet(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntrySet(data);
    }

    public static <T extends IForgeRegistryEntry<T>> Map<T, double[]> deserializeToMap(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntryMap(data);
    }

    public final <T extends Event> void addListener(Consumer<T> consumer) {
        this.addListener(consumer, EventPriority.NORMAL);
    }

    public final <T extends Event> void addListener(Consumer<T> consumer, boolean receiveCancelled) {
        this.addListener(consumer, EventPriority.NORMAL, receiveCancelled);
    }

    public final <T extends Event> void addListener(Consumer<T> consumer, EventPriority priority) {
        this.addListener(consumer, priority, false);
    }

    public final <T extends Event> void addListener(Consumer<T> consumer, EventPriority priority, boolean receiveCancelled) {
        this.events.add(new EventStorage<T>(consumer, priority, receiveCancelled));
    }

    private static class EventStorage<T extends Event> {
        private final Consumer<T> event;
        private final EventPriority priority;
        private final boolean receiveCancelled;
        private boolean active;

        EventStorage(Consumer<T> consumer, EventPriority priority, boolean receiveCancelled) {
            this.event = consumer;
            this.priority = priority;
            this.receiveCancelled = receiveCancelled;
        }

        void register() {
            if (this.isActive(true)) {
                MinecraftForge.EVENT_BUS.addListener(this.priority, this.receiveCancelled, this.event);
            }
        }

        void unregister() {
            if (this.isActive(false)) {
                MinecraftForge.EVENT_BUS.unregister(this.event);
            }
        }

        private boolean isActive(boolean newState) {
            if (this.active != newState) {
                this.active = newState;
                return true;
            }
            return false;
        }
    }
}

