Scriptname JMCR_Main extends Quest  
{Main script to handle cost modifiers and perks.}


GlobalVariable Property JMCR_Uninstall Auto
{Set to 1, if the player wants to uninstall the mod.}

JMCR_ModifierPerk[] Property Modifiers Auto
int Property NumberOfModifiers Auto


Event OnMenuClose(String MenuName)
	if MenuName == "Console"
		if JMCR_Uninstall.GetValueInt() == 1
			Disable()
			JMCR_Uninstall.SetValueInt(0)
		endif
	endif
EndEvent

Event OnInit()
	RegisterForMenu("Console")
	int i = 0
	while i < NumberOfModifiers
		Modifiers[i].InitModifier()
		i += 1
	endwhile
	Enable()
EndEvent

Function Enable()
	int i = 0
	while i < NumberOfModifiers
		Modifiers[i].EnableModifier()
		i += 1
	endwhile
EndFunction

; Remove all modifiers and the perks
Function Disable()
	int i = 0
	while i < NumberOfModifiers
		Modifiers[i].DisableModifier()
		i += 1
	endwhile
	Debug.MessageBox("BetterSpellCostStacking disabled. Save and quit, then uninstall the mod.")
EndFunction

; Reapply perk modifications
Function OnLoadSave()
	RegisterForMenu("Console")
	int i = 0
	while i < NumberOfModifiers
		Modifiers[i].OnLoadSaveModifier()
		i += 1
	endwhile
EndFunction
