Scriptname JMCR_EnchModifier extends activemagiceffect  

Actor property PlayerRef auto
JMCR_ModifierPerk property ModifierPerk auto

bool finished = false
int index = -1
int checkNumber = -1

Function First()
	float mag = 1.0 - GetMagnitude() * 0.01
	if mag < 0
		mag = 0
	endif
	index = ModifierPerk.AddModifier(mag)
	if index > 0
		checkNumber = ModifierPerk.GetcheckNumberModifier(index)
	endif
EndFunction

Function Last()
	if index > 0
		ModifierPerk.RemoveModifier(index, checkNumber)
	endif
EndFunction

; Waiting for the effect to start
Auto State InitState
	Event OnEffectStart(actor target, actor caster)
		GotoState("BusyState")
		if target != PlayerRef
			return
		endif
		First()
		; In case the effect finished while First() was running
		if finished
			Last()
		endif
		GotoState("ActiveState")
	EndEvent
	Event OnEffectFinish(actor target, actor caster)
		; In case the effect finished before it started
		GotoState("DisabledState")
	EndEvent
EndState

; Effect started, waiting for First() function to complete
State BusyState
	Event OnEffectFinish(actor target, actor caster)
		; In case the effect finished while First() was running
		finished = true
	EndEvent
EndState

; First() function completed, waiting for effect to finish
State ActiveState
	Event OnEffectFinish(actor target, actor caster)
		GotoState("DisabledState")
		if target != PlayerRef
			return
		endif
		Last()
	EndEvent
EndState

;Effect started and finished, do nothing
State DisabledState
	Event OnEffectFinish(actor target, actor caster)
	EndEvent
EndState
