/*
CActor {
	import var useHiResShadows : bool; default useHiResShadows = true;
    //...
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		//...
		activateMimicsAndHiResShadows(this);
	}
}
*/

function activateMimicsAndHiResShadows(actor: CActor) {
	var scene: CStoryScene;

	if (actor.IsHuman() && !actor.isDead) {
		actor.AddTag('MimicsTrigger');
		scene = (CStoryScene)LoadResource( "dlc/modEnableMimics/mimicstrigger.w2scene", true);
		theGame.GetStorySceneSystem().PlayScene(scene, "trigger");
		actor.RemoveTag('MimicsTrigger');
	}
}
